---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-next build

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **build/index.tsの内部処理フロー**: 1000行以上のファイルであり詳細は概要レベルの記述
  2. **Turbopackインクリメンタルビルドの記述**: コード直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-build.ts` - next buildコマンドの実装
- E-02: `packages/next/src/bin/next.ts` - CLIエントリーポイント（142-220行目）
- E-03: `packages/next/src/lib/bundler.ts` - バンドラー選択ロジック
- E-04: `packages/next/src/build/index.ts` - ビルドコア処理（冒頭80行のみ確認）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NextBuildOptionsは14のオプションプロパティを持つ | E-01 (19-36行目) | ○ |
| C-02 | SIGTERM/SIGINTでCPUプロファイルを保存して終了 | E-01 (39-46行目) | ○ |
| C-03 | --experimental-analyzeはTurbopack専用 | E-01 (68-72行目) | ○ |
| C-04 | --no-manglingでパフォーマンス警告を表示 | E-01 (74-78行目) | ○ |
| C-05 | --profileでパフォーマンス警告を表示 | E-01 (80-84行目) | ○ |
| C-06 | --debug-prerenderで本番非推奨の警告 | E-01 (86-92行目) | ○ |
| C-07 | メモリデバッグモードの有効化 | E-01 (94-97行目) | ○ |
| C-08 | ディレクトリ不在時にエラー終了 | E-01 (101-103行目) | ○ |
| C-09 | debug-build-pathsの解決処理 | E-01 (108-124行目) | ○ |
| C-10 | build()に10個の引数を渡す | E-01 (126-138行目) | ○ |
| C-11 | 6つの既知エラーコードの処理 | E-01 (147-152行目) | ○ |
| C-12 | メモリデバッグモードのfinally句でのクリーンアップ | E-01 (159-163行目) | ○ |
| C-13 | ビルド成功後にprocess.exit(0) | E-02 (216行目) | ○ |
| C-14 | CPUプロファイル保存はビルド成功後にも実行 | E-02 (213-215行目) | ○ |
| C-15 | experimentalBuildModeは4つの値を取る | E-01 (31行目), E-02 (173行目) | ○ |
| C-16 | バンドラー排他制御あり | E-03 (65-72行目) | ○ |
| C-17 | 500エラーページがビルド時に生成される | E-06 | ○ |
| C-18 | SIGTERMはexit code 143、SIGINTは130 | E-01 (41, 45行目) | ○ |
| C-19 | NEXT_DEBUG_BUILD環境変数でデバッグ有効化 | E-01 (130行目) | ○ |
| C-20 | Turbopackはインクリメンタルビルドで高速化 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Turbopackのインクリメンタルビルド機能はコードからは直接確認できなかった（Turbopack自体はRustで実装されているため）
  - 候補：Turbopackのドキュメント / Rustソースコード / 公式ブログ

## 5) リスクフラグ（レビュー観点）
- 0: build/index.tsの詳細処理フローは概要レベルの記述に留まる
- 0: マニフェスト生成の詳細はbuild/manifests/以下の実装に依存

## 6) レビュアーチェックリスト（最小）
- [ ] NextBuildOptionsの全パラメータが入力仕様に反映されているか
- [ ] 既知エラーコード6つが正確にリストされているか
- [ ] ビルドコア処理（build/index.ts）の概要が実装と一致しているか
- [ ] 関連画面（500エラーページ）のマッピングが正しいか
